module printCharList

//********************************************************************************
//  Clean 0.8 I/O library example program.
//
//  This program demonstrates the use of the function "printText1".
//  It instantiates the CharStreams class with the ListCharStream type. Objects
//  of type ListCharstream contain a list of characters, which should be printed.
//
//********************************************************************************

import StdEnv, deltaPrintText

:: *ListCharStream = { list :: [Char] , savedPos :: [Char] }

instance CharStreams ListCharStream
  where
    getChar sc=:{list}
        # empty = isEmpty list
        = ( not empty, if empty ' ' (hd list),
            { sc & list=if empty list (tl list) })
    savePos sc
        = { sc & savedPos=sc.list }
    restorePos sc
        = { sc & list=sc.savedPos }
    eos sc=:{list}
        = (isEmpty list,sc)

fontDef = ("Monaco", [], 12)

Start world
	# (defaultPS, world)	= defaultPrintSetup world
	= snd (accFiles	(printText1 True NoWrap fontDef 4
	       		                { list=['Hello printer'], savedPos=[] }
	            		        defaultPS)
            		world)
